﻿using System;
using System.Collections;
using System.Web.UI;
using Soneta.Kadry;
using Soneta.Business;
using Soneta.Types;
using Soneta.Tools;
using Soneta.Kasa;
using Soneta.Web.Business.App;
using Soneta.Web.Business.Kadry;
using System.Collections.Generic;
using Soneta.Kadry.UI.KadryNet.ViewInfo.PanelKierownika;
using Soneta.Langs;

namespace ASP {

    public partial class Szkolenia_Bhp : System.Web.UI.Page {

        public string Str_CultureInfo = "pl-PL";
        public string Str_Szkolenia = "SZKOLENIA BHP";
        public string Str_OkresAll = "(wszystko)";

        public class PrnParams: ContextBase {
	
		    public PrnParams(Context context): base(context) {
			    okres = GetOkres();
		    }
		
		    TypZakresu zakres = TypZakresu.Planowane;
		    [Caption("Zakres")]
            [DefaultWidth(19)]
            public TypZakresu Zakres {
			    get { return zakres ; }
			    set { 
				    zakres  = value; 
				    OnChanged(EventArgs.Empty);
			    }
		    }

            DefinicjaSzkoleniaBHP definicja;
            [Caption("Definicja")]
            public DefinicjaSzkoleniaBHP Definicja {
                get { return definicja; }
                set {
                    definicja = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            public object GetListDefinicja() {
                KadryModule kadry = KadryModule.GetInstance(this);
                Soneta.Business.View v = kadry.DefSzkolenBHP.WgNazwy.CreateView();
                v.Condition &= new FieldCondition.NotEqual("Blokada", true);
                return v;
            }

		    FromTo okres;
		    [Soneta.Business.Required]
		    [Caption("Raport za okres")]
		    public FromTo Okres {
			    get { return okres; }
			    set {
                    if (value == FromTo.Empty)
                        value = FromTo.All;
                    okres = value; 
				    OnChanged(EventArgs.Empty);
			    }
		    }			
		
		    FromTo GetOkres() {
			    return new YearMonth(ActualDate.Today(Context)).ToFromTo();
		    }
	    }
	
	    PrnParams pars = null; 
	    [Context(Required=true)] 
	    public PrnParams Params { 
		    get { return pars; }
            set { pars = value; }
        }

        RowCondition condition = RowCondition.Empty;

	    protected void OnContextLoad(Object sender, EventArgs args) {
		    // Odczytanie listy pracowników podległych z kontekstu
		    // Metoda znajduje się we wspólnej klasie dla strony raportu
		    // Soneta.Web.UI.ReportCorePage
            Row[] rows = getRows();

            ReportHeader1["NAZWA"] = pars.Definicja != null ? pars.Definicja.GetLocalizedNazwa(new System.Globalization.CultureInfo(Str_CultureInfo)) : Str_Szkolenia;
            ReportHeader1["OKRES"] = (pars.Okres != FromTo.All) ? pars.Okres.ToString() : Str_OkresAll;
            ReportHeader1["ZAKRES"] = CaptionAttribute.EnumToString(pars.Zakres, new System.Globalization.CultureInfo(Str_CultureInfo));

            if (pars.Definicja != null)
                condition &= new FieldCondition.In("Definicja", pars.Definicja);

            if (pars.Okres != FromTo.All)
                switch (pars.Zakres) {
                    case TypZakresu.Planowane:
                        condition &= new FieldCondition.Contain("Termin", pars.Okres);
                        break;
                    case TypZakresu.Aktualne:
                        condition &= (new FieldCondition.LessEqual("Data", pars.Okres.To) &
                            new FieldCondition.NotEqual("Data", Date.Empty));
                        condition &= (new FieldCondition.GreaterEqual("NastępneTermin", pars.Okres.From) |
                            new FieldCondition.Null("NastępneTermin", true));
                        break;
                    case TypZakresu.Odbyte:
                        condition &= new FieldCondition.Contain("Data", pars.Okres);
                        break;
                }

            Grid1.DataSource = rows;
	    }

        protected void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
            Pracownik prac = (Pracownik)args.Row;

            var v = KadryModule.GetInstance(prac).SzkoleniaBHP.WgDaty.CreateView();
            v.Condition &= new FieldCondition.Equal("Pracownik", prac);
            v.Condition &= condition;

            bool any = false;

            foreach (SzkolenieBHP bhp in v) {
                any = true;
                colNazwa.AddLine(bhp.Definicja.GetLocalizedNazwa(new System.Globalization.CultureInfo(Str_CultureInfo)));
                colTemat.AddLine(bhp.Zakres);
                colTermin.AddLine(bhp.Termin);
                colData.AddLine(bhp.Data);
            }

            args.VisibleRow = any;
        }

		private Row[] getRows() {
            //Soneta.Business.View v = Soneta.Web.Business.Kadry.Tools.GetPodwładni(dc);
            var podwladni = KadryModule.GetInstance(dc.Context).Pracownicy.CreateView();
            Soneta.KadryPlace.Kadry.KalkulatorPodwladnych kalkulator = new Soneta.KadryPlace.Kadry.KalkulatorPodwladnych(dc.Context.Session, dc.Context.Session.Login.WebUserInstance.Host.ID);
            podwladni.Condition &= kalkulator.FiltrPodległości(pars.Okres, false);
            List<Pracownik> list = new List<Pracownik>();
            foreach (Pracownik p in podwladni)
                list.Add(p);
            return list.ToArray();
        }
    }    
}
